/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class ExceptionTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) {
        Tester tester = factory.createTester(ExceptionTestCase::assertEquals);
        tester.accept(new StartException());
        tester.accept(new StartException("message"));
        tester.accept(new StartException((Throwable)new Exception()));
        tester.accept(new StartException("message", (Throwable)new Exception()));
        tester.accept(new ServiceNotFoundException());
        tester.accept(new ServiceNotFoundException("message"));
        tester.accept(new ServiceNotFoundException((Throwable)new Exception()));
        tester.accept(new ServiceNotFoundException("message", (Throwable)new Exception()));
    }

    private static void assertEquals(Throwable exception1, Throwable exception2) {
        if (exception1 != null && exception2 != null) {
            Assertions.assertSame(exception1.getClass(), exception2.getClass());
            Assertions.assertEquals((Object)exception1.getMessage(), (Object)exception2.getMessage());
            ExceptionTestCase.assertEquals(exception1.getCause(), exception2.getCause());
        } else {
            Assertions.assertSame((Object)exception1, (Object)exception2);
        }
    }
}

