/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ee.cache.SimpleManager;
import org.wildfly.clustering.web.cache.session.ConcurrentSessionManager;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

public class ConcurrentSessionManagerTestCase {
    @Test
    public void findSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, ConcurrentManager::new);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSession(id)).thenReturn((Object)expected1, (Object[])new Session[]{expected2});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.findSession(id);){
            Assert.assertNotNull((Object)session1);
            Assert.assertSame((Object)id, (Object)session1.getId());
            Assert.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assert.assertSame((Object)attributes1, (Object)session1.getAttributes());
            try (Session session2 = subject.findSession(id);){
                Assert.assertNotNull((Object)session2);
                Assert.assertSame((Object)session1, (Object)session2);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.findSession(id);){
            Assert.assertNotNull((Object)session);
            Assert.assertSame((Object)id, (Object)session.getId());
            Assert.assertSame((Object)metaData2, (Object)session.getMetaData());
            Assert.assertSame((Object)attributes2, (Object)session.getAttributes());
        }
    }

    @Test
    public void findInvalidSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, ConcurrentManager::new);
        Session expected1 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSession(id)).thenReturn((Object)expected1, (Object[])new Session[]{null});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        try (Session session1 = subject.findSession(id);){
            Assert.assertNotNull((Object)session1);
            Assert.assertSame((Object)id, (Object)session1.getId());
            Assert.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assert.assertSame((Object)attributes1, (Object)session1.getAttributes());
            session1.invalidate();
            ((Session)Mockito.verify((Object)expected1)).invalidate();
            ((Session)Mockito.verify((Object)expected1)).close();
            Session session2 = subject.findSession(id);
            Assert.assertNull((Object)session2);
        }
    }

    @Test
    public void createSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, ConcurrentManager::new);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.createSession(id)).thenReturn((Object)expected1, (Object[])new Session[]{expected2});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.createSession(id);){
            Assert.assertNotNull((Object)session1);
            Assert.assertSame((Object)id, (Object)session1.getId());
            Assert.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assert.assertSame((Object)attributes1, (Object)session1.getAttributes());
            try (Session session2 = subject.findSession(id);){
                Assert.assertNotNull((Object)session2);
                Assert.assertSame((Object)session1, (Object)session2);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.createSession(id);){
            Assert.assertNotNull((Object)session);
            Assert.assertSame((Object)id, (Object)session.getId());
            Assert.assertSame((Object)metaData2, (Object)session.getMetaData());
            Assert.assertSame((Object)attributes2, (Object)session.getAttributes());
        }
    }

    @Test
    public void getIdentifierFactory() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)manager.getIdentifierFactory()).thenReturn((Object)expected);
        Supplier result = subject.getIdentifierFactory();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void start() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        subject.start();
        ((SessionManager)Mockito.verify((Object)manager)).start();
    }

    @Test
    public void stop() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        subject.stop();
        ((SessionManager)Mockito.verify((Object)manager)).stop();
    }

    @Test
    public void getActiveSessionCount() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        long expected = 1000L;
        Mockito.when((Object)manager.getActiveSessionCount()).thenReturn((Object)expected);
        long result = subject.getActiveSessionCount();
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void getDefaultMaxInactiveInterval() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Duration expected = Duration.ofMinutes(60L);
        Mockito.when((Object)manager.getDefaultMaxInactiveInterval()).thenReturn((Object)expected);
        Duration result = subject.getDefaultMaxInactiveInterval();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void setDefaultMaxInactiveInterval() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Duration value = Duration.ofMinutes(60L);
        subject.setDefaultMaxInactiveInterval(value);
        ((SessionManager)Mockito.verify((Object)manager)).setDefaultMaxInactiveInterval(value);
    }

    @Test
    public void getBatcher() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Batcher expected = (Batcher)Mockito.mock(Batcher.class);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)expected);
        Batcher result = subject.getBatcher();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getActiveSessions() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Set<String> expected = Collections.singleton("foo");
        Mockito.when((Object)manager.getActiveSessions()).thenReturn(expected);
        Set result = subject.getActiveSessions();
        Assert.assertSame(expected, (Object)result);
    }

    @Test
    public void getLocalSessions() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Set<String> expected = Collections.singleton("foo");
        Mockito.when((Object)manager.getLocalSessions()).thenReturn(expected);
        Set result = subject.getLocalSessions();
        Assert.assertSame(expected, (Object)result);
    }

    @Test
    public void readSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        ImmutableSession expected = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        String id = "foo";
        Mockito.when((Object)manager.readSession(id)).thenReturn((Object)expected);
        ImmutableSession result = subject.readSession(id);
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getStopTimeout() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ConcurrentSessionManager subject = new ConcurrentSessionManager(manager, SimpleManager::new);
        Duration expected = Duration.ofMinutes(1L);
        Mockito.when((Object)manager.getStopTimeout()).thenReturn((Object)expected);
        Duration result = subject.getStopTimeout();
        Assert.assertSame((Object)expected, (Object)result);
    }
}

