/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData(Instant.now());
        SessionCreationMetaDataEntry entry = new SessionCreationMetaDataEntry((SessionCreationMetaData)metaData);
        metaData.setMaxInactiveInterval(Duration.ofMinutes(30L));
        tester.test((Object)entry, SessionCreationMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.setMaxInactiveInterval(Duration.ofMinutes(10L));
        tester.test((Object)entry, SessionCreationMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(SessionCreationMetaDataEntry<Object> entry1, SessionCreationMetaDataEntry<Object> entry2) {
        Assert.assertEquals((long)entry1.getMetaData().getCreationTime().toEpochMilli(), (long)entry2.getMetaData().getCreationTime().toEpochMilli());
        Assert.assertEquals((Object)entry1.getMetaData().getMaxInactiveInterval(), (Object)entry2.getMetaData().getMaxInactiveInterval());
    }
}

