/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.TreeMap;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributesFilter;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionActivationNotifierTestCase {
    private final HttpSessionActivationListenerProvider<Session, Context, Listener> provider = (HttpSessionActivationListenerProvider)Mockito.mock(HttpSessionActivationListenerProvider.class);
    private final ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
    private final Context context = (Context)Mockito.mock(Context.class);
    private final SessionAttributesFilter filter = (SessionAttributesFilter)Mockito.mock(SessionAttributesFilter.class);
    private final Listener listener1 = (Listener)Mockito.mock(Listener.class);
    private final Listener listener2 = (Listener)Mockito.mock(Listener.class);
    private final SessionActivationNotifier notifier = new ImmutableSessionActivationNotifier(this.provider, this.session, (Object)this.context, this.filter);

    @After
    public void destroy() {
        Mockito.reset((Object[])new Object[]{this.session, this.provider});
    }

    @Test
    public void test() {
        TreeMap<String, Listener> listeners = new TreeMap<String, Listener>();
        listeners.put("listener1", this.listener1);
        listeners.put("listener2", this.listener2);
        Mockito.when((Object)this.provider.getHttpSessionActivationListenerClass()).thenReturn(Listener.class);
        Mockito.when((Object)this.filter.getAttributes(Listener.class)).thenReturn(listeners);
        Session session = (Session)Mockito.mock(Session.class);
        Consumer prePassivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer prePassivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.provider.createHttpSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.provider.prePassivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)prePassivateNotifier1);
        Mockito.when((Object)this.provider.prePassivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)prePassivateNotifier2);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)postActivateNotifier1);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)postActivateNotifier2);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
        Mockito.reset((Object[])new Consumer[]{postActivateNotifier1, postActivateNotifier2});
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        Mockito.reset((Object[])new Consumer[]{prePassivateNotifier1, prePassivateNotifier2});
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
    }

    @Test
    public void postActivate() {
        TreeMap<String, Listener> listeners = new TreeMap<String, Listener>();
        listeners.put("listener1", this.listener1);
        listeners.put("listener2", this.listener2);
        Mockito.when((Object)this.provider.getHttpSessionActivationListenerClass()).thenReturn(Listener.class);
        Mockito.when((Object)this.filter.getAttributes(Listener.class)).thenReturn(listeners);
        Session session = (Session)Mockito.mock(Session.class);
        Consumer notifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer notifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.provider.createHttpSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)notifier1);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)notifier2);
        this.notifier.postActivate();
        ((HttpSessionActivationListenerProvider)Mockito.verify(this.provider, (VerificationMode)Mockito.never())).prePassivateNotifier((Object)this.listener1);
        ((HttpSessionActivationListenerProvider)Mockito.verify(this.provider, (VerificationMode)Mockito.never())).prePassivateNotifier((Object)this.listener2);
        ((Consumer)Mockito.verify((Object)notifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)notifier2)).accept(session);
    }

    static interface Listener {
    }

    static interface Context {
    }

    static interface Session {
    }
}

