/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionFactoryTestCase {
    private final SessionMetaDataFactory<CompositeSessionMetaDataEntry<Object>> metaDataFactory = (SessionMetaDataFactory)Mockito.mock(SessionMetaDataFactory.class);
    private final SessionAttributesFactory<Object, Object> attributesFactory = (SessionAttributesFactory)Mockito.mock(SessionAttributesFactory.class);
    private final LocalContextFactory<Object> localContextFactory = (LocalContextFactory)Mockito.mock(LocalContextFactory.class);
    private final SessionFactory<Object, CompositeSessionMetaDataEntry<Object>, Object, Object> factory = new CompositeSessionFactory(this.metaDataFactory, this.attributesFactory, this.localContextFactory);

    @Test
    public void createValue() {
        SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
        AtomicReference localContext = new AtomicReference();
        CompositeSessionMetaDataEntry metaData = new CompositeSessionMetaDataEntry(creationMetaData, accessMetaData, localContext);
        Object attributes = new Object();
        String id = "id";
        Mockito.when((Object)((CompositeSessionMetaDataEntry)this.metaDataFactory.createValue((Object)id, null))).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.createValue((Object)id, null)).thenReturn(attributes);
        Map.Entry result = (Map.Entry)this.factory.createValue((Object)id, null);
        Assert.assertNotNull((Object)result);
        Assert.assertSame((Object)metaData, result.getKey());
        Assert.assertSame((Object)attributes, result.getValue());
    }

    @Test
    public void findValue() {
        String missingMetaDataSessionId = "no-meta-data";
        String missingAttributesSessionId = "no-attributes";
        String existingSessionId = "existing";
        SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
        AtomicReference localContext = new AtomicReference();
        CompositeSessionMetaDataEntry metaData = new CompositeSessionMetaDataEntry(creationMetaData, accessMetaData, localContext);
        Object attributes = new Object();
        Mockito.when((Object)((CompositeSessionMetaDataEntry)this.metaDataFactory.findValue((Object)missingMetaDataSessionId))).thenReturn(null);
        Mockito.when((Object)((CompositeSessionMetaDataEntry)this.metaDataFactory.findValue((Object)missingAttributesSessionId))).thenReturn((Object)metaData);
        Mockito.when((Object)((CompositeSessionMetaDataEntry)this.metaDataFactory.findValue((Object)existingSessionId))).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.findValue((Object)missingAttributesSessionId)).thenReturn(null);
        Mockito.when((Object)this.attributesFactory.findValue((Object)existingSessionId)).thenReturn(attributes);
        Map.Entry missingMetaDataResult = (Map.Entry)this.factory.findValue((Object)missingMetaDataSessionId);
        Map.Entry missingAttributesResult = (Map.Entry)this.factory.findValue((Object)missingAttributesSessionId);
        Map.Entry existingSessionResult = (Map.Entry)this.factory.findValue((Object)existingSessionId);
        Assert.assertNull((Object)missingMetaDataResult);
        Assert.assertNull((Object)missingAttributesResult);
        Assert.assertNotNull((Object)existingSessionResult);
        Assert.assertSame((Object)metaData, existingSessionResult.getKey());
        Assert.assertSame((Object)attributes, existingSessionResult.getValue());
    }

    @Test
    public void remove() {
        String id = "id";
        Mockito.when((Object)this.metaDataFactory.remove((Object)id)).thenReturn((Object)false);
        boolean removed = this.factory.remove((Object)id);
        ((SessionAttributesFactory)Mockito.verify(this.attributesFactory)).remove((Object)id);
        Assert.assertFalse((boolean)removed);
        Mockito.reset((Object[])new SessionAttributesFactory[]{this.attributesFactory});
        Mockito.when((Object)this.metaDataFactory.remove((Object)id)).thenReturn((Object)true);
        removed = this.factory.remove((Object)id);
        ((SessionAttributesFactory)Mockito.verify(this.attributesFactory)).remove((Object)id);
        Assert.assertTrue((boolean)removed);
    }

    @Test
    public void getMetaDataFactory() {
        Assert.assertSame(this.metaDataFactory, (Object)this.factory.getMetaDataFactory());
    }

    @Test
    public void createSession() {
        Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
        SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
        Object localContext = new Object();
        CompositeSessionMetaDataEntry metaDataValue = new CompositeSessionMetaDataEntry(creationMetaData, accessMetaData, new AtomicReference<Object>(localContext));
        Object attributesValue = new Object();
        InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Object context = new Object();
        String id = "id";
        Mockito.when((Object)((CompositeSessionMetaDataEntry)entry.getKey())).thenReturn((Object)metaDataValue);
        Mockito.when(entry.getValue()).thenReturn(attributesValue);
        Mockito.when((Object)this.metaDataFactory.createSessionMetaData(id, (Object)metaDataValue)).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.createSessionAttributes((String)Mockito.same((Object)id), Mockito.same((Object)attributesValue), (ImmutableSessionMetaData)Mockito.same((Object)metaData), Mockito.same((Object)context))).thenReturn((Object)attributes);
        Session result = this.factory.createSession(id, entry, context);
        Assert.assertSame((Object)id, (Object)result.getId());
        Assert.assertSame((Object)metaData, (Object)result.getMetaData());
        Assert.assertSame((Object)attributes, (Object)result.getAttributes());
        Assert.assertSame((Object)localContext, (Object)result.getLocalContext());
    }

    @Test
    public void createImmutableSession() {
        Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
        SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
        CompositeSessionMetaDataEntry metaDataValue = new CompositeSessionMetaDataEntry(creationMetaData, accessMetaData, null);
        Object attributesValue = new Object();
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        String id = "id";
        Mockito.when((Object)((CompositeSessionMetaDataEntry)entry.getKey())).thenReturn((Object)metaDataValue);
        Mockito.when(entry.getValue()).thenReturn(attributesValue);
        Mockito.when((Object)this.metaDataFactory.createImmutableSessionMetaData(id, (Object)metaDataValue)).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.createImmutableSessionAttributes(id, attributesValue)).thenReturn((Object)attributes);
        ImmutableSession result = this.factory.createImmutableSession(id, entry);
        Assert.assertSame((Object)id, (Object)result.getId());
        Assert.assertSame((Object)metaData, (Object)result.getMetaData());
        Assert.assertSame((Object)attributes, (Object)result.getAttributes());
    }

    @Test
    public void close() {
        this.factory.close();
        ((SessionMetaDataFactory)Mockito.verify(this.metaDataFactory)).close();
        ((SessionAttributesFactory)Mockito.verify(this.attributesFactory)).close();
    }
}

