/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeSession;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionTestCase {
    private final String id = "session";
    private final InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
    private final SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
    private final Remover<String> remover = (Remover)Mockito.mock(Remover.class);
    private final LocalContextFactory<Object> localContextFactory = (LocalContextFactory)Mockito.mock(LocalContextFactory.class);
    private final AtomicReference<Object> localContextRef = new AtomicReference();
    private final Session<Object> session = new CompositeSession(this.id, this.metaData, this.attributes, this.localContextRef, this.localContextFactory, this.remover);

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void getAttributes() {
        Assert.assertSame((Object)this.attributes, (Object)this.session.getAttributes());
    }

    @Test
    public void getMetaData() {
        Assert.assertSame((Object)this.metaData, (Object)this.session.getMetaData());
    }

    @Test
    public void invalidate() {
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)true);
        this.session.invalidate();
        ((Remover)Mockito.verify(this.remover)).remove((Object)this.id);
        Mockito.reset((Object[])new Remover[]{this.remover});
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)false);
        this.session.invalidate();
        ((Remover)Mockito.verify(this.remover, (VerificationMode)Mockito.never())).remove((Object)this.id);
    }

    @Test
    public void isValid() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.session.isValid());
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.session.isValid());
    }

    @Test
    public void close() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes)).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData)).close();
        Mockito.reset((Object[])new AutoCloseable[]{this.metaData, this.attributes});
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes, (VerificationMode)Mockito.never())).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void getLocalContext() {
        Object expected = new Object();
        Mockito.when((Object)this.localContextFactory.createLocalContext()).thenReturn(expected);
        Object result = this.session.getLocalContext();
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.reset((Object[])new LocalContextFactory[]{this.localContextFactory});
        result = this.session.getLocalContext();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.localContextFactory});
        Assert.assertSame((Object)expected, (Object)result);
    }
}

