/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CompositeSessionMetaDataTestCase {
    private final SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
    private final SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
    private final SessionMetaData metaData = new CompositeSessionMetaData(this.creationMetaData, this.accessMetaData);

    @Test
    public void isNew() {
        Mockito.when((Object)this.creationMetaData.isNew()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.metaData.isNew());
        Mockito.when((Object)this.creationMetaData.isNew()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.metaData.isNew());
    }

    @Test
    public void isExpired() {
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)Instant.now().minus(Duration.ofMinutes(10L)));
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(10L));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)Duration.ofMinutes(5L));
        Mockito.when((Object)this.accessMetaData.getLastAccessDuration()).thenReturn((Object)Duration.ofSeconds(1L));
        Assert.assertFalse((boolean)this.metaData.isExpired());
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(5L).minus(Duration.ofSeconds(1L, 1L)));
        Assert.assertTrue((boolean)this.metaData.isExpired());
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ZERO);
        Assert.assertFalse((boolean)this.metaData.isExpired());
    }

    @Test
    public void getCreationTime() {
        Instant expected = Instant.now();
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = this.metaData.getCreationTime();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getLastAccessStartTime() {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Instant result = this.metaData.getLastAccessStartTime();
        Assert.assertEquals((Object)now, (Object)result);
    }

    @Test
    public void getLastAccessTime() {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Duration lastAccess = Duration.ofSeconds(1L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation).minus(lastAccess));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Mockito.when((Object)this.accessMetaData.getLastAccessDuration()).thenReturn((Object)lastAccess);
        Instant result = this.metaData.getLastAccessTime();
        Assert.assertEquals((Object)now, (Object)result);
    }

    @Test
    public void getMaxInactiveInterval() {
        Duration expected = Duration.ofMinutes(30L);
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)expected);
        Duration result = this.metaData.getTimeout();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void setLastAccessedTime() {
        Instant endTime = Instant.now();
        Duration lastAccess = Duration.ofSeconds(1L);
        Instant startTime = endTime.minus(lastAccess);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)startTime);
        this.metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)this.accessMetaData)).setLastAccessDuration(Duration.ZERO, lastAccess);
        Mockito.reset((Object[])new Object[]{this.creationMetaData, this.accessMetaData});
        Duration sinceCreated = Duration.ofSeconds(10L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)startTime.minus(sinceCreated));
        this.metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)this.accessMetaData)).setLastAccessDuration(sinceCreated, lastAccess);
    }

    @Test
    public void setMaxInactiveInterval() {
        Duration duration = Duration.ZERO;
        this.metaData.setMaxInactiveInterval(duration);
        ((SessionCreationMetaData)Mockito.verify((Object)this.creationMetaData)).setTimeout(duration);
    }
}

