/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.io.IOException;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;

public class SessionAccessMetaDataMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        SimpleSessionAccessMetaData metaData = new SimpleSessionAccessMetaData();
        metaData.setLastAccessDuration(Duration.ZERO, Duration.ofNanos(100000000L));
        tester.test((Object)metaData, SessionAccessMetaDataMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofNanos(100000000L));
        tester.test((Object)metaData, SessionAccessMetaDataMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofSeconds(1L, 100000000L));
        tester.test((Object)metaData, SessionAccessMetaDataMarshallerTestCase::assertEquals);
    }

    static void assertEquals(SimpleSessionAccessMetaData metaData1, SimpleSessionAccessMetaData metaData2) {
        Assert.assertEquals((Object)metaData1.getSinceCreationDuration(), (Object)metaData2.getSinceCreationDuration());
        Assert.assertEquals((Object)metaData1.getLastAccessDuration(), (Object)metaData2.getLastAccessDuration());
    }
}

