/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.IOException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.function.MapPutFunction;
import org.wildfly.clustering.ee.cache.function.MapRemoveFunction;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.web.cache.session.fine.ConcurrentSessionAttributeMapPutFunction;
import org.wildfly.clustering.web.cache.session.fine.ConcurrentSessionAttributeMapRemoveFunction;
import org.wildfly.clustering.web.cache.session.fine.CopyOnWriteSessionAttributeMapPutFunction;
import org.wildfly.clustering.web.cache.session.fine.CopyOnWriteSessionAttributeMapRemoveFunction;

public class SessionAttributeMapFunctionMarshallerTestCase {
    @Test
    public void testMapPutFunction() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)new ConcurrentSessionAttributeMapPutFunction("foo", UUID.randomUUID()), SessionAttributeMapFunctionMarshallerTestCase::assertEquals);
        tester.test((Object)new CopyOnWriteSessionAttributeMapPutFunction("foo", UUID.randomUUID()), SessionAttributeMapFunctionMarshallerTestCase::assertEquals);
    }

    @Test
    public void testMapRemoveFunction() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)new ConcurrentSessionAttributeMapRemoveFunction("foo"), SessionAttributeMapFunctionMarshallerTestCase::assertEquals);
        tester.test((Object)new CopyOnWriteSessionAttributeMapRemoveFunction("foo"), SessionAttributeMapFunctionMarshallerTestCase::assertEquals);
    }

    static <K, V> void assertEquals(MapPutFunction<K, V> function1, MapPutFunction<K, V> function2) {
        Assert.assertEquals((Object)function1.getOperand(), (Object)function2.getOperand());
    }

    static <K, V> void assertEquals(MapRemoveFunction<K, V> function1, MapRemoveFunction<K, V> function2) {
        Assert.assertEquals((Object)function1.getOperand(), (Object)function2.getOperand());
    }
}

