/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntry;

public abstract class AbstractSessionMetaDataEntryTestCase
implements Consumer<ContextualSessionMetaDataEntry<Object>> {
    private final Instant originalLastAccessEndTime = Instant.now();
    private final Instant originalLastAccessStartTime = this.originalLastAccessEndTime.minus(Duration.ofSeconds(1L));
    private final Instant created = this.originalLastAccessStartTime.minus(Duration.ofMinutes(1L));
    private final Duration originalTimeout = Duration.ofMinutes(20L);
    private final Instant updatedLastAccessStartTime = this.originalLastAccessEndTime.plus(Duration.ofSeconds(10L));
    private final Instant updatedLastAccessEndTime = this.updatedLastAccessStartTime.plus(Duration.ofSeconds(2L));
    private final Duration updatedTimeout = Duration.ofMinutes(30L);

    @Test
    public void test() {
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry(this.created);
        Assert.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assert.assertEquals((Object)this.created, (Object)entry.getLastAccessStartTime().get());
        Assert.assertEquals((Object)this.created, (Object)entry.getLastAccessEndTime().get());
        Assert.assertEquals((Object)Duration.ZERO, (Object)entry.getTimeout());
        Assert.assertNull((Object)entry.getContext(() -> null));
        entry.getLastAccessStartTime().set((Object)this.originalLastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)this.originalLastAccessEndTime);
        entry.setTimeout(this.originalTimeout);
        this.verifyOriginalState((SessionMetaDataEntry)entry);
        this.accept(entry);
    }

    void updateState(SessionMetaDataEntry entry) {
        entry.getLastAccessStartTime().set((Object)this.updatedLastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)this.updatedLastAccessEndTime);
        entry.setTimeout(this.updatedTimeout);
    }

    void verifyOriginalState(SessionMetaDataEntry entry) {
        Assert.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assert.assertEquals((Object)this.originalLastAccessStartTime, (Object)entry.getLastAccessStartTime().get());
        Assert.assertEquals((Object)this.originalLastAccessEndTime, (Object)entry.getLastAccessEndTime().get());
        Assert.assertEquals((Object)this.originalTimeout, (Object)entry.getTimeout());
    }

    void verifyUpdatedState(SessionMetaDataEntry entry) {
        Assert.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assert.assertEquals((Object)this.updatedLastAccessStartTime, (Object)entry.getLastAccessStartTime().get());
        Assert.assertEquals((Object)this.updatedLastAccessEndTime, (Object)entry.getLastAccessEndTime().get());
        Assert.assertEquals((Object)this.updatedTimeout, (Object)entry.getTimeout());
    }
}

