/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.util.UUID;
import org.junit.Assert;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.web.cache.session.metadata.coarse.AbstractSessionMetaDataEntryTestCase;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataOffsetValues;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntryFunction;
import org.wildfly.common.function.Functions;

public class SessionMetaDataEntryFunctionTestCase
extends AbstractSessionMetaDataEntryTestCase {
    @Override
    public void accept(ContextualSessionMetaDataEntry<Object> entry) {
        UUID context = UUID.randomUUID();
        Assert.assertSame((Object)context, (Object)entry.getContext(Functions.constantSupplier((Object)context)));
        Assert.assertSame((Object)context, (Object)entry.getContext(Functions.constantSupplier(null)));
        MutableSessionMetaDataOffsetValues delta = MutableSessionMetaDataOffsetValues.from(entry);
        MutableSessionMetaDataEntry mutableEntry = new MutableSessionMetaDataEntry(entry, delta);
        this.updateState((SessionMetaDataEntry)mutableEntry);
        this.verifyOriginalState((SessionMetaDataEntry)entry);
        Key key = (Key)Mockito.mock(Key.class);
        ContextualSessionMetaDataEntry resultEntry = (ContextualSessionMetaDataEntry)new SessionMetaDataEntryFunction(delta).apply((Object)key, entry);
        Mockito.verifyNoInteractions((Object[])new Object[]{key});
        this.verifyUpdatedState((SessionMetaDataEntry)resultEntry);
        Assert.assertSame((Object)context, (Object)resultEntry.getContext(Functions.constantSupplier(null)));
    }
}

