/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.CompositeImmutableSessionMetaDataTestCase;
import org.wildfly.clustering.web.cache.session.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeSessionMetaDataTestCase
extends CompositeImmutableSessionMetaDataTestCase {
    private final SessionCreationMetaData creationMetaData;
    private final SessionAccessMetaData accessMetaData;
    private final Mutator mutator;
    private final InvalidatableSessionMetaData metaData;

    public CompositeSessionMetaDataTestCase() {
        this((SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class), (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class), (Mutator)Mockito.mock(Mutator.class));
    }

    private CompositeSessionMetaDataTestCase(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Mutator mutator) {
        this(creationMetaData, accessMetaData, mutator, (InvalidatableSessionMetaData)new CompositeSessionMetaData(creationMetaData, accessMetaData, mutator));
    }

    private CompositeSessionMetaDataTestCase(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Mutator mutator, InvalidatableSessionMetaData metaData) {
        super((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
        this.mutator = mutator;
        this.metaData = metaData;
    }

    @Test
    public void setLastAccessedTime() {
        Instant endTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        Duration lastAccess = Duration.ofSeconds(1L);
        Instant startTime = endTime.minus(lastAccess);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)startTime);
        this.metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)this.accessMetaData)).setLastAccessDuration(Duration.ZERO, lastAccess);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Mockito.reset((Object[])new Object[]{this.creationMetaData, this.accessMetaData});
        Duration sinceCreated = Duration.ofSeconds(10L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)startTime.minus(sinceCreated));
        this.metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)this.accessMetaData)).setLastAccessDuration(sinceCreated, lastAccess);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Test
    public void setMaxInactiveInterval() {
        Duration duration = Duration.ZERO;
        this.metaData.setTimeout(duration);
        ((SessionCreationMetaData)Mockito.verify((Object)this.creationMetaData)).setTimeout(duration);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Test
    public void close() {
        this.metaData.close();
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
    }
}

