/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.FineSessionMetaDataSerializationContextInitializer;

public class DefaultSessionAccessMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.createTester(List.of(new FineSessionMetaDataSerializationContextInitializer()));
        DefaultSessionAccessMetaDataEntry metaData = new DefaultSessionAccessMetaDataEntry();
        metaData.setLastAccessDuration(Duration.ZERO, Duration.ofNanos(100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofNanos(100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofSeconds(1L, 100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(DefaultSessionAccessMetaDataEntry metaData1, DefaultSessionAccessMetaDataEntry metaData2) {
        Assert.assertEquals((Object)metaData1.getSinceCreationDuration(), (Object)metaData2.getSinceCreationDuration());
        Assert.assertEquals((Object)metaData1.getLastAccessDuration(), (Object)metaData2.getLastAccessDuration());
    }
}

