/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.cache.Contextual;
import org.wildfly.clustering.web.cache.session.CompositeSession;
import org.wildfly.clustering.web.cache.session.attributes.SessionAttributes;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionTestCase {
    private final String id = "session";
    private final InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
    private final SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
    private final Remover<String> remover = (Remover)Mockito.mock(Remover.class);
    private final Supplier<Object> contextFactory = (Supplier)Mockito.mock(Supplier.class);
    private final Contextual<Object> contextual = (Contextual)Mockito.mock(Contextual.class);
    private final Session<Object> session = new CompositeSession(this.id, this.metaData, this.attributes, this.contextual, this.contextFactory, this.remover);

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void getAttributes() {
        Assert.assertSame((Object)this.attributes, (Object)this.session.getAttributes());
    }

    @Test
    public void getMetaData() {
        Assert.assertSame((Object)this.metaData, (Object)this.session.getMetaData());
    }

    @Test
    public void invalidate() {
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)true);
        this.session.invalidate();
        ((Remover)Mockito.verify(this.remover)).remove((Object)this.id);
        Mockito.reset((Object[])new Remover[]{this.remover});
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)false);
        this.session.invalidate();
        ((Remover)Mockito.verify(this.remover, (VerificationMode)Mockito.never())).remove((Object)this.id);
    }

    @Test
    public void isValid() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.session.isValid());
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.session.isValid());
    }

    @Test
    public void close() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes)).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData)).close();
        Mockito.reset((Object[])new AutoCloseable[]{this.metaData, this.attributes});
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes, (VerificationMode)Mockito.never())).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void getLocalContext() {
        Object expected = new Object();
        ((Contextual)Mockito.doReturn((Object)expected).when(this.contextual)).getContext(this.contextFactory);
        Object result = this.session.getLocalContext();
        Assert.assertSame((Object)expected, (Object)result);
    }
}

