/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntry;

public abstract class AbstractSessionAccessMetaDataEntryTestCase
implements Consumer<SessionAccessMetaDataEntry> {
    private final Duration originalSinceCreation = Duration.ofMinutes(1L);
    private final Duration originalLastAccess = Duration.ofSeconds(1L);
    private final Duration updatedSinceCreation = Duration.ofMinutes(2L);
    private final Duration updatedLastAccess = Duration.ofSeconds(2L);

    @Test
    public void test() {
        DefaultSessionAccessMetaDataEntry entry = new DefaultSessionAccessMetaDataEntry();
        Assert.assertTrue((boolean)entry.getSinceCreationDuration().isZero());
        Assert.assertTrue((boolean)entry.getLastAccessDuration().isZero());
        entry.setLastAccessDuration(this.originalSinceCreation, this.originalLastAccess);
        this.verifyOriginalState((SessionAccessMetaData)entry);
        this.accept(entry);
    }

    void updateState(SessionAccessMetaData entry) {
        entry.setLastAccessDuration(this.updatedSinceCreation, this.updatedLastAccess);
    }

    void verifyOriginalState(SessionAccessMetaData metaData) {
        Assert.assertEquals((Object)this.originalSinceCreation, (Object)metaData.getSinceCreationDuration());
        Assert.assertEquals((Object)this.originalLastAccess, (Object)metaData.getLastAccessDuration());
    }

    void verifyUpdatedState(SessionAccessMetaData metaData) {
        Assert.assertEquals((Object)this.updatedSinceCreation, (Object)metaData.getSinceCreationDuration());
        Assert.assertEquals((Object)this.updatedLastAccess, (Object)metaData.getLastAccessDuration());
    }
}

