/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultImmutableSessionMetaDataTestCase;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class DefaultSessionMetaDataTestCase
extends DefaultImmutableSessionMetaDataTestCase {
    private final MutableSessionMetaDataEntry entry;
    private final Mutator mutator;
    private final InvalidatableSessionMetaData metaData;

    public DefaultSessionMetaDataTestCase() {
        this((MutableSessionMetaDataEntry)Mockito.mock(MutableSessionMetaDataEntry.class), (Mutator)Mockito.mock(Mutator.class));
    }

    private DefaultSessionMetaDataTestCase(MutableSessionMetaDataEntry entry, Mutator mutator) {
        this(entry, mutator, (InvalidatableSessionMetaData)new DefaultSessionMetaData((SessionMetaDataEntry)entry, mutator));
    }

    private DefaultSessionMetaDataTestCase(MutableSessionMetaDataEntry entry, Mutator mutator, InvalidatableSessionMetaData metaData) {
        super((ImmutableSessionMetaDataEntry)entry, (ImmutableSessionMetaData)metaData);
        this.entry = entry;
        this.mutator = mutator;
        this.metaData = metaData;
    }

    @Override
    public void testCreationTime() {
        super.testCreationTime();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Override
    public void testLastAccessStartTime() {
        super.testLastAccessStartTime();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Override
    public void testLastAccessEndTime() {
        super.testLastAccessEndTime();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Override
    public void testTimeout() {
        super.testTimeout();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Test
    public void setLastAccess() {
        Instant endTime = Instant.now();
        Instant startTime = endTime.minus(Duration.ofMillis(500L));
        OffsetValue lastAccessStartTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        OffsetValue lastAccessEndTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ArgumentCaptor lastAccessStartTimeCaptor = ArgumentCaptor.forClass(Instant.class);
        ArgumentCaptor lastAccessEndTimeCaptor = ArgumentCaptor.forClass(Instant.class);
        ((MutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessStartTime).when((Object)this.entry)).getLastAccessStartTime();
        ((MutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessEndTime).when((Object)this.entry)).getLastAccessEndTime();
        ((OffsetValue)Mockito.doNothing().when((Object)lastAccessStartTime)).set((Object)((Instant)lastAccessStartTimeCaptor.capture()));
        ((OffsetValue)Mockito.doNothing().when((Object)lastAccessEndTime)).set((Object)((Instant)lastAccessEndTimeCaptor.capture()));
        this.metaData.setLastAccess(startTime, endTime);
        Instant normalizedStartTime = (Instant)lastAccessStartTimeCaptor.getValue();
        Instant normalizedEndTime = (Instant)lastAccessEndTimeCaptor.getValue();
        Assert.assertEquals((long)0L, (long)(normalizedStartTime.getNano() % Duration.ofMillis(1L).getNano()));
        Assert.assertEquals((long)startTime.toEpochMilli(), (long)normalizedStartTime.toEpochMilli());
        Duration lastAccessDuration = Duration.between(normalizedStartTime, normalizedEndTime);
        Assert.assertEquals((long)1L, (long)lastAccessDuration.getSeconds());
        Assert.assertEquals((long)0L, (long)lastAccessDuration.getNano());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Test
    public void setTimeout() {
        Duration timeout = Duration.ofHours(1L);
        this.metaData.setTimeout(timeout);
        ((MutableSessionMetaDataEntry)Mockito.verify((Object)this.entry)).setTimeout(timeout);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
    }

    @Test
    public void invalidate() {
        Assert.assertTrue((boolean)this.metaData.isValid());
        this.metaData.invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mutator});
        Assert.assertFalse((boolean)this.metaData.isValid());
    }

    @Test
    public void close() {
        this.metaData.close();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
    }
}

