/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.cache.session.metadata.fine.CompositeImmutableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeImmutableSessionMetaDataTestCase {
    private final ImmutableSessionCreationMetaData creationMetaData;
    private final ImmutableSessionAccessMetaData accessMetaData;
    private final ImmutableSessionMetaData metaData;

    public CompositeImmutableSessionMetaDataTestCase() {
        this((ImmutableSessionCreationMetaData)Mockito.mock(ImmutableSessionCreationMetaData.class), (ImmutableSessionAccessMetaData)Mockito.mock(ImmutableSessionAccessMetaData.class));
    }

    private CompositeImmutableSessionMetaDataTestCase(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData) {
        this(creationMetaData, accessMetaData, (ImmutableSessionMetaData)new CompositeImmutableSessionMetaData(creationMetaData, accessMetaData));
    }

    CompositeImmutableSessionMetaDataTestCase(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        this.metaData = metaData;
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    @Test
    public void isNew() {
        Mockito.when((Object)this.accessMetaData.isNew()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.metaData.isNew());
        Mockito.when((Object)this.accessMetaData.isNew()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.metaData.isNew());
    }

    @Test
    public void isExpired() {
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)Instant.now().minus(Duration.ofMinutes(10L)));
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(10L));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)Duration.ofMinutes(5L));
        Mockito.when((Object)this.accessMetaData.getLastAccessDuration()).thenReturn((Object)Duration.ofSeconds(1L));
        Assert.assertFalse((boolean)this.metaData.isExpired());
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(5L).minus(Duration.ofSeconds(1L, 1L)));
        Assert.assertTrue((boolean)this.metaData.isExpired());
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)Duration.ZERO);
        Assert.assertFalse((boolean)this.metaData.isExpired());
    }

    @Test
    public void getCreationTime() {
        Instant expected = Instant.now();
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = this.metaData.getCreationTime();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getLastAccessStartTime() {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Instant result = this.metaData.getLastAccessStartTime();
        Assert.assertEquals((Object)now, (Object)result);
    }

    @Test
    public void getLastAccessEndTime() {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Duration lastAccess = Duration.ofSeconds(1L);
        Mockito.when((Object)this.creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation).minus(lastAccess));
        Mockito.when((Object)this.accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Mockito.when((Object)this.accessMetaData.getLastAccessDuration()).thenReturn((Object)lastAccess);
        Instant result = this.metaData.getLastAccessEndTime();
        Assert.assertEquals((Object)now, (Object)result);
    }

    @Test
    public void getMaxInactiveInterval() {
        Duration expected = Duration.ofMinutes(30L);
        Mockito.when((Object)this.creationMetaData.getTimeout()).thenReturn((Object)expected);
        Duration result = this.metaData.getTimeout();
        Assert.assertSame((Object)expected, (Object)result);
    }
}

