/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.util.UUID;
import org.junit.Assert;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.ee.cache.offset.Value;
import org.wildfly.clustering.web.cache.session.metadata.fine.AbstractSessionCreationMetaDataEntryTestCase;
import org.wildfly.clustering.web.cache.session.metadata.fine.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntryFunction;
import org.wildfly.common.function.Functions;

public class SessionCreationMetaDataEntryFunctionTestCase
extends AbstractSessionCreationMetaDataEntryTestCase {
    @Override
    public void accept(SessionCreationMetaDataEntry<Object> entry) {
        UUID context = UUID.randomUUID();
        Assert.assertSame((Object)context, (Object)entry.getContext(Functions.constantSupplier((Object)context)));
        Assert.assertSame((Object)context, (Object)entry.getContext(Functions.constantSupplier(null)));
        OffsetValue timeoutOffset = OffsetValue.from((Duration)entry.getTimeout());
        MutableSessionCreationMetaData mutableEntry = new MutableSessionCreationMetaData(entry, (Value)timeoutOffset);
        this.updateState((SessionCreationMetaData)mutableEntry);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        Key key = (Key)Mockito.mock(Key.class);
        SessionCreationMetaDataEntry resultEntry = (SessionCreationMetaDataEntry)new SessionCreationMetaDataEntryFunction(timeoutOffset).apply((Object)key, entry);
        Mockito.verifyNoInteractions((Object[])new Object[]{key});
        this.verifyUpdatedState((SessionCreationMetaData)resultEntry);
        Assert.assertSame((Object)context, (Object)resultEntry.getContext(Functions.constantSupplier(null)));
    }
}

