/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.attributes.coarse;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.cache.session.attributes.coarse.ImmutableSessionAttributesFilter;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class ImmutableSessionAttributesFilterTestCase {
    @Test
    public void getListeners() {
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        ImmutableSessionAttributesFilter filter = new ImmutableSessionAttributesFilter(attributes);
        Object object1 = new Object();
        Object object2 = new Object();
        Runnable listener1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable listener2 = (Runnable)Mockito.mock(Runnable.class);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(new HashSet<String>(Arrays.asList("non-listener1", "non-listener2", "listener1", "listener2")));
        Mockito.when((Object)attributes.getAttribute("non-listener1")).thenReturn(object1);
        Mockito.when((Object)attributes.getAttribute("non-listener2")).thenReturn(object2);
        Mockito.when((Object)attributes.getAttribute("listener1")).thenReturn((Object)listener1);
        Mockito.when((Object)attributes.getAttribute("listener2")).thenReturn((Object)listener2);
        Map result = filter.getAttributes(Runnable.class);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)result.toString(), (boolean)result.containsKey("listener1"));
        Assert.assertTrue((String)result.toString(), (boolean)result.containsKey("listener2"));
        Assert.assertSame((Object)listener1, result.get("listener1"));
        Assert.assertSame((Object)listener2, result.get("listener2"));
    }
}

