/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultImmutableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class DefaultImmutableSessionMetaDataTestCase {
    private final ImmutableSessionMetaDataEntry entry;
    private final ImmutableSessionMetaData metaData;

    public DefaultImmutableSessionMetaDataTestCase() {
        this((ImmutableSessionMetaDataEntry)Mockito.mock(ImmutableSessionMetaDataEntry.class));
    }

    private DefaultImmutableSessionMetaDataTestCase(ImmutableSessionMetaDataEntry entry) {
        this(entry, (ImmutableSessionMetaData)new DefaultImmutableSessionMetaData(entry));
    }

    DefaultImmutableSessionMetaDataTestCase(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        this.entry = entry;
        this.metaData = metaData;
    }

    @Test
    public void testCreationTime() {
        Instant expected = Instant.now();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)expected).when((Object)this.entry)).getCreationTime();
        Instant result = this.metaData.getCreationTime();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void testLastAccessStartTime() {
        Instant expected = Instant.now();
        OffsetValue lastAccessStartTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessStartTime).when((Object)this.entry)).getLastAccessStartTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessStartTime)).get();
        Instant result = this.metaData.getLastAccessStartTime();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void testLastAccessEndTime() {
        Instant expected = Instant.now();
        OffsetValue lastAccessEndTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessEndTime).when((Object)this.entry)).getLastAccessEndTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessEndTime)).get();
        Instant result = this.metaData.getLastAccessEndTime();
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertEquals((Object)expected, (Object)this.metaData.getLastAccessTime());
    }

    @Test
    public void testTimeout() {
        Duration expected = Duration.ofMinutes(60L);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)expected).when((Object)this.entry)).getTimeout();
        Duration result = this.metaData.getTimeout();
        Assert.assertSame((Object)expected, (Object)result);
    }
}

