/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.offset.Offset;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.web.cache.session.metadata.coarse.CoarseSessionMetaDataSerializationContextInitializer;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultSessionMetaDataEntry;

public class DefaultSessionMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.createTester(List.of(new CoarseSessionMetaDataSerializationContextInitializer()));
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry(Instant.now());
        entry.setTimeout(Duration.ofMinutes(30L));
        entry.getLastAccessEndTime().setOffset(Offset.forInstant((Duration)Duration.ofSeconds(1L)));
        tester.test((Object)entry, DefaultSessionMetaDataEntryMarshallerTestCase::assertEquals);
        Instant lastAccessStartTime = Instant.now();
        entry.getLastAccessStartTime().set((Object)lastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)lastAccessStartTime.plus(Duration.ofSeconds(2L)));
        tester.test((Object)entry, DefaultSessionMetaDataEntryMarshallerTestCase::assertEquals);
        entry.setTimeout(Duration.ofMinutes(10L));
        tester.test((Object)entry, DefaultSessionMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(ContextualSessionMetaDataEntry<Object> entry1, ContextualSessionMetaDataEntry<Object> entry2) {
        Assert.assertEquals((long)((Instant)entry1.getLastAccessStartTime().getBasis()).toEpochMilli(), (long)((Instant)entry2.getLastAccessStartTime().getBasis()).toEpochMilli());
        Assert.assertEquals((Object)entry1.getTimeout(), (Object)entry2.getTimeout());
        Assert.assertEquals((Object)entry1.getLastAccessStartTime().get(), (Object)entry2.getLastAccessStartTime().get());
        Assert.assertEquals((Object)entry1.getLastAccessEndTime().get(), (Object)entry2.getLastAccessEndTime().get());
    }
}

