/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.web.cache.session.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntry;

public abstract class AbstractSessionCreationMetaDataEntryTestCase
implements Consumer<SessionCreationMetaDataEntry<Object>> {
    private final Instant created = Instant.now();
    private final Duration originalTimeout = Duration.ofMinutes(20L);
    private final Duration updatedTimeout = Duration.ofMinutes(30L);

    @Test
    public void test() {
        DefaultSessionCreationMetaDataEntry entry = new DefaultSessionCreationMetaDataEntry(this.created);
        Assert.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assert.assertEquals((Object)Duration.ZERO, (Object)entry.getTimeout());
        Assert.assertNull((Object)entry.getContext(() -> null));
        entry.setTimeout(this.originalTimeout);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        this.accept(entry);
    }

    void updateState(SessionCreationMetaData metaData) {
        metaData.setTimeout(this.updatedTimeout);
    }

    void verifyOriginalState(SessionCreationMetaData metaData) {
        Assert.assertEquals((Object)this.created, (Object)metaData.getCreationTime());
        Assert.assertEquals((Object)this.originalTimeout, (Object)metaData.getTimeout());
    }

    void verifyUpdatedState(SessionCreationMetaData metaData) {
        Assert.assertEquals((Object)this.created, (Object)metaData.getCreationTime());
        Assert.assertEquals((Object)this.updatedTimeout, (Object)metaData.getTimeout());
    }
}

