/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.sso;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.cache.sso.CompositeSSO;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class CompositeSSOTestCase {
    private final String id = "id";
    private final String authentication = "auth";
    private final Sessions<String, String> sessions = (Sessions)Mockito.mock(Sessions.class);
    private final AtomicReference<Object> localContext = new AtomicReference();
    private final Supplier<Object> localContextFactory = (Supplier)Mockito.mock(Supplier.class);
    private final Remover<String> remover = (Remover)Mockito.mock(Remover.class);
    private final SSO<String, String, String, Object> sso = new CompositeSSO(this.id, (Object)this.authentication, this.sessions, this.localContext, this.localContextFactory, this.remover);

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.sso.getId());
    }

    @Test
    public void getAuthentication() {
        Assert.assertSame((Object)this.authentication, (Object)this.sso.getAuthentication());
    }

    @Test
    public void getSessions() {
        Assert.assertSame(this.sessions, (Object)this.sso.getSessions());
    }

    @Test
    public void invalidate() {
        this.sso.invalidate();
        ((Remover)Mockito.verify(this.remover)).remove((Object)this.id);
    }

    @Test
    public void getLocalContext() {
        Object expected = new Object();
        Mockito.when((Object)this.localContextFactory.get()).thenReturn(expected);
        Object result = this.sso.getLocalContext();
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.reset((Object[])new Supplier[]{this.localContextFactory});
        result = this.sso.getLocalContext();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.localContextFactory});
        Assert.assertSame((Object)expected, (Object)result);
    }
}

