/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.sso.coarse;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.web.cache.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.sso.Sessions;

public class CoarseSessionsTestCase {
    private Mutator mutator = (Mutator)Mockito.mock(Mutator.class);
    private Map<String, String> map = (Map)Mockito.mock(Map.class);
    private Sessions<String, String> sessions = new CoarseSessions(this.map, this.mutator);

    @Test
    public void getApplications() {
        Set<String> expected = Collections.singleton("deployment");
        Mockito.when(this.map.keySet()).thenReturn(expected);
        Set result = this.sessions.getDeployments();
        Assert.assertEquals(expected, (Object)result);
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void getSession() {
        String expected = "id";
        String deployment = "deployment1";
        String missingDeployment = "deployment2";
        Mockito.when((Object)this.map.get(deployment)).thenReturn((Object)expected);
        Mockito.when((Object)this.map.get(missingDeployment)).thenReturn(null);
        Assert.assertSame((Object)expected, (Object)this.sessions.getSession((Object)deployment));
        Assert.assertNull((Object)this.sessions.getSession((Object)missingDeployment));
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void addSession() {
        String id = "id";
        String deployment = "deployment";
        Mockito.when((Object)this.map.put(deployment, id)).thenReturn(null);
        this.sessions.addSession((Object)deployment, (Object)id);
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
        Mockito.reset((Object[])new Object[]{this.map, this.mutator});
        Mockito.when((Object)this.map.put(deployment, id)).thenReturn((Object)id);
        this.sessions.addSession((Object)deployment, (Object)id);
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void removeSession() {
        String deployment = "deployment";
        Mockito.when((Object)this.map.remove(deployment)).thenReturn((Object)"id");
        this.sessions.removeSession((Object)deployment);
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
        Mockito.reset((Object[])new Object[]{this.map, this.mutator});
        Mockito.when((Object)this.map.remove(deployment)).thenReturn(null);
        this.sessions.removeSession((Object)deployment);
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }
}

