/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.catalina.session;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.wildfly.clustering.web.session.SessionContext;

public class SessionContextAdapter
implements SessionContext {
    private final Context context;

    public SessionContextAdapter(Context context) {
        this.context = context;
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public Iterable<HttpSessionAttributeListener> getSessionAttributeListeners() {
        return new FilteredIterable<HttpSessionAttributeListener>(this.context.getApplicationEventListeners(), HttpSessionAttributeListener.class);
    }

    public Iterable<HttpSessionListener> getSessionListeners() {
        return new FilteredIterable<HttpSessionListener>(this.context.getApplicationSessionLifecycleListeners(), HttpSessionListener.class);
    }

    private static class FilteringIterator<T>
    implements Iterator<T> {
        private final Iterator<?> objects;
        private final Class<T> targetClass;
        private volatile T next;

        FilteringIterator(List<?> list, Class<T> targetClass) {
            this.objects = list.iterator();
            this.targetClass = targetClass;
            this.next = this.findNext();
        }

        private T findNext() {
            while (this.objects.hasNext()) {
                Object object = this.objects.next();
                if (!this.targetClass.isInstance(object)) continue;
                return this.targetClass.cast(object);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T next = this.next;
            this.next = this.findNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FilteredIterable<T>
    implements Iterable<T> {
        private final List<?> objects;
        private final Class<T> targetClass;

        FilteredIterable(Object[] objects, Class<T> targetClass) {
            this(Arrays.asList(objects), targetClass);
        }

        FilteredIterable(List<?> objects, Class<T> targetClass) {
            this.objects = objects;
            this.targetClass = targetClass;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteringIterator<T>(this.objects, this.targetClass);
        }
    }
}

