/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.service.InfinispanCacheConfigurationAttributeGroup;
import org.wildfly.clustering.server.service.CacheConfigurationAttributeGroup;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.extension.clustering.web.PrimaryOwnerAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.RankedAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class InfinispanSessionManagementResourceDefinition
extends SessionManagementResourceDefinition {
    static final PathElement WILDCARD_PATH = InfinispanSessionManagementResourceDefinition.pathElement("*");
    static final CacheConfigurationAttributeGroup CACHE_ATTRIBUTE_GROUP = new InfinispanCacheConfigurationAttributeGroup(SESSION_MANAGEMENT_PROVIDER);

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"infinispan-session-management", (String)name);
    }

    InfinispanSessionManagementResourceDefinition() {
        super(WILDCARD_PATH, new UnaryOperator<ResourceDescriptor>(){

            @Override
            public ResourceDescriptor apply(ResourceDescriptor descriptor) {
                return descriptor.addAttributes((Iterable)CACHE_ATTRIBUTE_GROUP.getAttributes()).addRequiredSingletonChildren(new PathElement[]{PrimaryOwnerAffinityResourceDefinition.PATH});
            }
        });
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PrimaryOwnerAffinityResourceDefinition().register(registration);
        new RankedAffinityResourceDefinition().register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ServiceDependency locatorProvider = ServiceDependency.on((UnaryServiceDescriptor)RouteLocatorProvider.SERVICE_DESCRIPTOR, (String)context.getCurrentAddressValue());
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(SessionManagementResourceDefinition.SESSION_MANAGEMENT_PROVIDER, (Object)new InfinispanSessionManagementProvider(this.resolve(context, model), CACHE_ATTRIBUTE_GROUP.resolve(context, model), (Supplier<RouteLocatorProvider>)locatorProvider)).requires((Consumer)locatorProvider)).build();
    }
}

