/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.UUID;
import javax.servlet.ServletContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class HotRodSessionManagerFactory<C extends Marshallability>
implements SessionManagerFactory<Batch> {
    private final HotRodSessionManagerFactoryConfiguration<C> config;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<C> config) {
        this.config = config;
    }

    public <L> SessionManager<L, Batch> createSessionManager(final SessionManagerConfiguration<L> configuration) {
        HotRodSessionManagerConfiguration config = new HotRodSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }
        };
        return new HotRodSessionManager(this.createSessionFactory(configuration.getLocalContextFactory()), config);
    }

    private <L> SessionFactory<?, ?, ?, L> createSessionFactory(LocalContextFactory<L> localContextFactory) {
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(this.config.getSessionManagerFactoryConfiguration().getDeploymentName(), this.config.getCache());
        return new HotRodSessionFactory(metaDataFactory, this.createSessionAttributesFactory(), localContextFactory);
    }

    private SessionAttributesFactory<UUID, ?> createSessionAttributesFactory() {
        SessionManagerFactoryConfiguration<C> config = this.config.getSessionManagerFactoryConfiguration();
        MarshalledValueFactory factory = config.getMarshalledValueFactory();
        Marshallability context = config.getMarshallingContext();
        switch (this.config.getSessionManagerFactoryConfiguration().getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(this.config.getCache(), this.config.getCache(), new MarshalledValueMarshaller(factory, context));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(this.config.getCache(), new MarshalledValueMarshaller(factory, context));
            }
        }
        throw new IllegalStateException();
    }
}

