/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;
import org.wildfly.clustering.marshalling.spi.time.InstantExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UUIDExternalizer;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryExternalizer
implements Externalizer<SessionCreationMetaDataEntry<UUID, Object>> {
    private static final Externalizer<UUID> UUID_EXTERNALIZER = new UUIDExternalizer();
    private static final Externalizer<Instant> INSTANT_EXTERNALIZER = new InstantExternalizer();

    public void writeObject(ObjectOutput output, SessionCreationMetaDataEntry<UUID, Object> entry) throws IOException {
        UUID_EXTERNALIZER.writeObject(output, (Object)entry.getKey());
        SessionCreationMetaData metaData = entry.getMetaData();
        INSTANT_EXTERNALIZER.writeObject(output, (Object)metaData.getCreationTime());
        IndexExternalizer.VARIABLE.writeObject(output, Integer.valueOf((int)metaData.getMaxInactiveInterval().getSeconds()));
    }

    public SessionCreationMetaDataEntry<UUID, Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        UUID key = (UUID)UUID_EXTERNALIZER.readObject(input);
        Instant created = (Instant)INSTANT_EXTERNALIZER.readObject(input);
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData(created);
        metaData.setMaxInactiveInterval(Duration.ofSeconds(IndexExternalizer.VARIABLE.readObject(input).intValue()));
        return new SessionCreationMetaDataEntry<UUID, Object>(key, metaData);
    }

    public Class<SessionCreationMetaDataEntry<UUID, Object>> getTargetClass() {
        return SessionCreationMetaDataEntry.class;
    }
}

