/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.web.IdentifierExternalizerProvider;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;

public class SessionCreationMetaDataKeyExternalizer
implements Externalizer<SessionCreationMetaDataKey> {
    private static final Externalizer<String> EXTERNALIZER = ((IdentifierExternalizerProvider)StreamSupport.stream(ServiceLoader.load(IdentifierExternalizerProvider.class, IdentifierExternalizerProvider.class.getClassLoader()).spliterator(), false).findFirst().get()).getExternalizer();

    public void writeObject(ObjectOutput output, SessionCreationMetaDataKey key) throws IOException {
        output.writeUTF(key.getDeployment());
        EXTERNALIZER.writeObject(output, key.getId());
    }

    public SessionCreationMetaDataKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String deployment = input.readUTF();
        String sessionId = (String)EXTERNALIZER.readObject(input);
        return new SessionCreationMetaDataKey(deployment, sessionId);
    }

    public Class<SessionCreationMetaDataKey> getTargetClass() {
        return SessionCreationMetaDataKey.class;
    }
}

