/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<K, V>
implements ImmutableSessionAttributes {
    private final K key;
    private final Map<String, Integer> names;
    private final RemoteCache<SessionAttributeKey<K>, V> cache;
    private final Function<Integer, SessionAttributeKey<K>> keyFactory;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(K key, Map<String, Integer> names, RemoteCache<SessionAttributeKey<K>, V> cache, Function<Integer, SessionAttributeKey<K>> keyFactory, Marshaller<Object, V> marshaller) {
        this.key = key;
        this.names = names;
        this.cache = cache;
        this.keyFactory = keyFactory;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        Integer attributeId = this.names.get(name);
        return attributeId != null ? this.read(name, this.cache.get(this.keyFactory.apply(attributeId))) : null;
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw Logger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.key.toString(), name);
        }
    }
}

