/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.hotrod.Keyed;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.SessionFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class ExpiredSessionRemover<K, MV extends Keyed<K>, AV, L>
implements Remover<String> {
    private final SessionFactory<K, MV, AV, L> factory;
    private final SessionExpirationListener listener;

    public ExpiredSessionRemover(SessionFactory<K, MV, AV, L> factory, SessionExpirationListener listener) {
        this.factory = factory;
        this.listener = listener;
    }

    public boolean remove(String id) {
        ImmutableSessionMetaData metaData;
        Keyed metaDataValue = (Keyed)this.factory.getMetaDataFactory().tryValue(id);
        if (metaDataValue != null && (metaData = this.factory.getMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue)).isExpired()) {
            Object key = metaDataValue.getKey();
            Object attributesValue = this.factory.getAttributesFactory().findValue(key);
            if (attributesValue != null) {
                ImmutableSessionAttributes attributes = this.factory.getAttributesFactory().createImmutableSessionAttributes(key, attributesValue);
                ImmutableSession session = this.factory.createImmutableSession(id, metaData, attributes);
                Logger.ROOT_LOGGER.tracef("Session %s has expired.", id);
                this.listener.sessionExpired(session);
            }
            return this.factory.remove(id);
        }
        return false;
    }
}

