/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodImmutableSession;
import org.wildfly.clustering.web.hotrod.session.HotRodSession;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionEntry;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.SessionEntry;
import org.wildfly.clustering.web.hotrod.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class HotRodSessionFactory<K, V, L>
implements SessionFactory<K, HotRodSessionMetaData<K, L>, V, L> {
    private final SessionMetaDataFactory<K, HotRodSessionMetaData<K, L>, L> metaDataFactory;
    private final SessionAttributesFactory<K, V> attributesFactory;
    private final LocalContextFactory<L> localContextFactory;

    public HotRodSessionFactory(SessionMetaDataFactory<K, HotRodSessionMetaData<K, L>, L> metaDataFactory, SessionAttributesFactory<K, V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public SessionEntry<K, HotRodSessionMetaData<K, L>, V> createValue(String id, Void context) {
        HotRodSessionMetaData metaDataValue = (HotRodSessionMetaData)this.metaDataFactory.createValue(id, context);
        if (metaDataValue == null) {
            return null;
        }
        Object key = metaDataValue.getKey();
        Object attributesValue = this.attributesFactory.createValue(key, context);
        return new HotRodSessionEntry(key, metaDataValue, attributesValue);
    }

    public SessionEntry<K, HotRodSessionMetaData<K, L>, V> findValue(String id) {
        HotRodSessionMetaData metaData = (HotRodSessionMetaData)this.metaDataFactory.findValue(id);
        if (metaData != null) {
            Object key = metaData.getKey();
            Object attributes = this.attributesFactory.findValue(key);
            if (attributes != null) {
                return new HotRodSessionEntry(key, metaData, attributes);
            }
            this.metaDataFactory.remove(id);
        }
        return null;
    }

    public boolean remove(String id) {
        K key = this.metaDataFactory.remove(id);
        if (key == null) {
            return false;
        }
        this.attributesFactory.remove(key);
        return true;
    }

    @Override
    public SessionMetaDataFactory<K, HotRodSessionMetaData<K, L>, L> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<K, V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, SessionEntry<K, HotRodSessionMetaData<K, L>, V> entry) {
        HotRodSessionMetaData<K, L> metaDataValue = entry.getMetaDataValue();
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, metaDataValue);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(entry.getKey(), entry.getAttributesValue());
        return new HotRodSession<L>(id, metaData, attributes, metaDataValue.getLocalContext(), this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new HotRodImmutableSession(id, metaData, attributes);
    }
}

