/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.UUID;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<L>
implements SessionMetaDataFactory<UUID, HotRodSessionMetaData<UUID, L>, L> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<UUID, L>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey<UUID>, SessionAccessMetaData> accessMetaDataCache;
    private final Function<String, SessionCreationMetaDataKey> creationMetaDataKeyFactory;
    private final Function<UUID, SessionAccessMetaDataKey<UUID>> accessMetaDataKeyFactory;

    public HotRodSessionMetaDataFactory(String deployment, RemoteCache<?, ?> cache) {
        this.creationMetaDataCache = cache;
        this.accessMetaDataCache = cache;
        this.creationMetaDataKeyFactory = id -> new SessionCreationMetaDataKey(deployment, (String)id);
        this.accessMetaDataKeyFactory = id -> new SessionAccessMetaDataKey<UUID>((UUID)id);
    }

    public HotRodSessionMetaData<UUID, L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(UUID.randomUUID(), new SimpleSessionCreationMetaData());
        if (this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)this.creationMetaDataKeyFactory.apply(id), creationMetaDataEntry) != null) {
            return null;
        }
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        this.accessMetaDataCache.put(this.accessMetaDataKeyFactory.apply(creationMetaDataEntry.getKey()), (Object)accessMetaData);
        return new HotRodSessionMetaData(creationMetaDataEntry, accessMetaData);
    }

    public HotRodSessionMetaData<UUID, L> findValue(String id) {
        SessionCreationMetaDataKey key = this.creationMetaDataKeyFactory.apply(id);
        VersionedValue value = this.creationMetaDataCache.getVersioned((Object)key);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.get((Object)key);
        if (creationMetaDataEntry != null) {
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get(this.accessMetaDataKeyFactory.apply((UUID)creationMetaDataEntry.getKey()));
            if (accessMetaData != null) {
                return new HotRodSessionMetaData(creationMetaDataEntry, accessMetaData);
            }
            this.creationMetaDataCache.removeWithVersion((Object)key, value.getVersion());
        }
        return null;
    }

    @Override
    public InvalidatableSessionMetaData createSessionMetaData(String id, HotRodSessionMetaData<UUID, L> entry) {
        SessionCreationMetaDataKey creationMetaDataKey = this.creationMetaDataKeyFactory.apply(id);
        RemoteCacheEntryMutator creationMutator = new RemoteCacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, new SessionCreationMetaDataEntry<UUID, L>(entry));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), (Mutator)creationMutator);
        SessionAccessMetaDataKey<UUID> accessMetaDataKey = this.accessMetaDataKeyFactory.apply(entry.getKey());
        RemoteCacheEntryMutator accessMutator = new RemoteCacheEntryMutator(this.accessMetaDataCache, accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), (Mutator)accessMutator);
        return new SimpleSessionMetaData(creationMetaData, accessMetaData);
    }

    @Override
    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, HotRodSessionMetaData<UUID, L> entry) {
        return new SimpleSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    @Override
    public UUID remove(String id) {
        SessionCreationMetaDataKey key = this.creationMetaDataKeyFactory.apply(id);
        SessionCreationMetaDataEntry creationMetaData = (SessionCreationMetaDataEntry)this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key);
        if (creationMetaData == null) {
            return null;
        }
        UUID uuid = (UUID)creationMetaData.getKey();
        this.accessMetaDataCache.remove(this.accessMetaDataKeyFactory.apply(uuid));
        return uuid;
    }
}

