/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.util.UUIDExternalizer;
import org.wildfly.clustering.web.hotrod.SessionKey;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;

public class SessionKeyExternalizer<K extends SessionKey<UUID>>
implements Externalizer<K> {
    private static final Externalizer<UUID> UUID_EXTERNALIZER = new UUIDExternalizer();
    private final Class<K> targetClass;
    private final ExceptionBiFunction<UUID, ObjectInput, K, IOException> resolver;
    private final ExceptionBiConsumer<K, ObjectOutput, IOException> writer;

    public SessionKeyExternalizer(Class<K> targetClass, ExceptionBiFunction<UUID, ObjectInput, K, IOException> resolver, ExceptionBiConsumer<K, ObjectOutput, IOException> writer) {
        this.targetClass = targetClass;
        this.resolver = resolver;
        this.writer = writer;
    }

    public SessionKeyExternalizer(Class<K> targetClass, Function<UUID, K> resolver) {
        this(targetClass, (id, input) -> (SessionKey)resolver.apply((UUID)id), (key, output) -> {});
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        UUID_EXTERNALIZER.writeObject(output, ((SessionKey)key).getId());
        this.writer.accept(key, (Object)output);
    }

    public K readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        UUID id = (UUID)UUID_EXTERNALIZER.readObject(input);
        return (K)((SessionKey)this.resolver.apply((Object)id, (Object)input));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

