/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.coarse;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class CoarseSessionAttributesFactory<V>
implements SessionAttributesFactory<Map.Entry<Map<String, Object>, V>> {
    private final RemoteCache<SessionAttributesKey, V> cache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final CacheProperties properties;

    public CoarseSessionAttributesFactory(RemoteCache<SessionAttributesKey, V> cache, Marshaller<Map<String, Object>, V> marshaller, CacheProperties properties) {
        this.cache = cache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public Map.Entry<Map<String, Object>, V> createValue(String id, Void context) {
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        Object value = this.marshaller.write(attributes);
        this.cache.put((Object)new SessionAttributesKey(id), value);
        return new AbstractMap.SimpleImmutableEntry(attributes, value);
    }

    public Map.Entry<Map<String, Object>, V> findValue(String id) {
        Object value = this.cache.get((Object)new SessionAttributesKey(id));
        if (value != null) {
            try {
                Map attributes = (Map)this.marshaller.read(value);
                return new AbstractMap.SimpleImmutableEntry<Map, Object>(attributes, value);
            }
            catch (InvalidSerializedFormException e) {
                Logger.ROOT_LOGGER.failedToActivateSession(e, id.toString());
                this.remove(id);
            }
        }
        return null;
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry) {
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.cache, (Object)new SessionAttributesKey(id), entry.getValue());
        return new CoarseSessionAttributes(entry.getKey(), (Mutator)mutator, (Marshallability)this.marshaller, this.properties);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry) {
        return new CoarseImmutableSessionAttributes(entry.getKey());
    }

    public boolean remove(String id) {
        this.cache.remove((Object)new SessionAttributesKey(id));
        return true;
    }
}

