/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;

public class CompositeSessionMetaData
implements InvalidatableSessionMetaData {
    private final SessionCreationMetaData creationMetaData;
    private final SessionAccessMetaData accessMetaData;

    public CompositeSessionMetaData(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    public boolean isNew() {
        return this.accessMetaData.getLastAccessedDuration().isZero();
    }

    @Override
    public boolean isValid() {
        return this.creationMetaData.isValid();
    }

    @Override
    public boolean invalidate() {
        return this.creationMetaData.invalidate();
    }

    public boolean isExpired() {
        Duration maxInactiveInterval = this.getMaxInactiveInterval();
        return !maxInactiveInterval.isZero() ? this.getLastAccessedTime().plus(maxInactiveInterval).isBefore(Instant.now()) : false;
    }

    public Instant getCreationTime() {
        return this.creationMetaData.getCreationTime();
    }

    public Instant getLastAccessedTime() {
        return this.getCreationTime().plus(this.accessMetaData.getLastAccessedDuration());
    }

    public Duration getMaxInactiveInterval() {
        return this.creationMetaData.getMaxInactiveInterval();
    }

    public void setLastAccessedTime(Instant instant) {
        this.accessMetaData.setLastAccessedDuration(Duration.between(this.creationMetaData.getCreationTime(), instant));
    }

    public void setMaxInactiveInterval(Duration duration) {
        this.creationMetaData.setMaxInactiveInterval(duration.isNegative() ? Duration.ZERO : duration);
    }
}

