/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapPutFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapPutFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapRemoveFunction;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final String id;
    private final RemoteCache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final RemoteCache<SessionAttributeKey, V> attributeCache;
    private final Map<String, Mutator> mutations = new ConcurrentHashMap<String, Mutator>();
    private final Marshaller<Object, V> marshaller;
    private final CacheProperties properties;
    private volatile Map<String, UUID> names;

    public FineSessionAttributes(String id, Map<String, UUID> names, RemoteCache<SessionAttributeNamesKey, Map<String, UUID>> namesCache, RemoteCache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, CacheProperties properties) {
        super(id, names, attributeCache, marshaller);
        this.id = id;
        this.names = names;
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        UUID attributeId = this.names.remove(name);
        if (attributeId == null) {
            return null;
        }
        this.setNames((Map)this.namesCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).computeIfPresent((Object)this.createKey(), (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteMapRemoveFunction((Object)name) : new ConcurrentMapRemoveFunction((Object)name))));
        Object result = this.read(name, this.attributeCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)this.createKey(attributeId)));
        this.mutations.remove(name);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (!this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException(new NotSerializableException(attribute.getClass().getName()));
        }
        Object value = this.marshaller.write(attribute);
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            UUID newAttributeId = UUID.randomUUID();
            this.setNames((Map)this.namesCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).compute((Object)this.createKey(), (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteMapPutFunction((Object)name, (Object)newAttributeId) : new ConcurrentMapPutFunction((Object)name, (Object)newAttributeId))));
            attributeId = this.names.get(name);
        }
        Object result = this.read(name, this.attributeCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)this.createKey(attributeId), value));
        this.mutations.remove(name);
        return result;
    }

    @Override
    public Object getAttribute(String name) {
        RemoteCacheEntryMutator mutator;
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        SessionAttributeKey key = this.createKey(attributeId);
        Object value = this.attributeCache.get((Object)key);
        Object attribute = this.read(name, value);
        if (attribute != null && !SessionAttributeImmutability.INSTANCE.test(attribute) && this.mutations.putIfAbsent(name, (Mutator)(mutator = new RemoteCacheEntryMutator(this.attributeCache, (Object)key, value))) == null && this.properties.isTransactional()) {
            mutator.mutate();
        }
        return attribute;
    }

    @Override
    public void close() {
        if (!this.properties.isTransactional()) {
            for (Mutator mutator : this.mutations.values()) {
                mutator.mutate();
            }
        }
        this.mutations.clear();
    }

    private void setNames(Map<String, UUID> names) {
        this.names = names != null ? Collections.unmodifiableMap(names) : Collections.emptyMap();
    }

    private SessionAttributeNamesKey createKey() {
        return new SessionAttributeNamesKey(this.id);
    }

    private SessionAttributeKey createKey(UUID attributeId) {
        return new SessionAttributeKey(this.id, attributeId);
    }
}

