/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.io.IOException;
import java.util.UUID;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.UUIDBuilder;
import org.wildfly.clustering.marshalling.protostream.util.UUIDMarshaller;
import org.wildfly.clustering.web.cache.SessionIdentifierMarshaller;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;

public class SessionAttributeKeyMarshaller
implements ProtoStreamMarshaller<SessionAttributeKey> {
    private static final int SESSION_IDENTIFIER_INDEX = 1;
    private static final int ATTRIBUTE_IDENTIFIER_INDEX = 2;

    public SessionAttributeKey readFrom(ProtoStreamReader reader) throws IOException {
        String sessionId = null;
        UUIDBuilder attributeId = UUIDMarshaller.INSTANCE.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index == 1) {
                sessionId = SessionIdentifierMarshaller.INSTANCE.readFrom(reader);
                continue;
            }
            if (index >= 2 && index < 2 + UUIDMarshaller.INSTANCE.getFields()) {
                attributeId = UUIDMarshaller.INSTANCE.readField(reader, index - 2, attributeId);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new SessionAttributeKey(sessionId, (UUID)attributeId.build());
    }

    public void writeTo(ProtoStreamWriter writer, SessionAttributeKey key) throws IOException {
        writer.writeTag(1, SessionIdentifierMarshaller.INSTANCE.getWireType());
        SessionIdentifierMarshaller.INSTANCE.writeTo(writer, (String)key.getId());
        UUIDMarshaller.INSTANCE.writeFields(writer, 2, key.getAttributeId());
    }

    public Class<? extends SessionAttributeKey> getJavaClass() {
        return SessionAttributeKey.class;
    }
}

