/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.ee.hotrod.RemoteCacheKey;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMutatorFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<L>
implements SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> {
    private final RemoteCache<Key<String>, Object> cache;
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final MutatorFactory<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataMutatorFactory;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final MutatorFactory<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataMutatorFactory;
    private final CacheProperties properties;

    public HotRodSessionMetaDataFactory(HotRodConfiguration configuration) {
        this.cache = configuration.getCache();
        this.creationMetaDataCache = configuration.getCache();
        this.creationMetaDataMutatorFactory = new RemoteCacheMutatorFactory(this.creationMetaDataCache, new Function<SessionCreationMetaDataEntry<L>, Duration>(){

            @Override
            public Duration apply(SessionCreationMetaDataEntry<L> entry) {
                return entry.getMetaData().getTimeout();
            }
        });
        this.accessMetaDataCache = configuration.getCache();
        this.accessMetaDataMutatorFactory = new RemoteCacheMutatorFactory(this.accessMetaDataCache);
        this.properties = configuration.getCacheProperties();
    }

    public CompositeSessionMetaDataEntry<L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry((SessionCreationMetaData)new SimpleSessionCreationMetaData());
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        this.creationMetaDataMutatorFactory.createMutator((Object)new SessionCreationMetaDataKey(id), (Object)creationMetaDataEntry).mutate();
        this.accessMetaDataMutatorFactory.createMutator((Object)new SessionAccessMetaDataKey(id), (Object)accessMetaData).mutate();
        return new CompositeSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaData)accessMetaData);
    }

    public CompositeSessionMetaDataEntry<L> findValue(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        HashSet<RemoteCacheKey> keys = new HashSet<RemoteCacheKey>(3);
        keys.add(creationMetaDataKey);
        keys.add(accessMetaDataKey);
        Map entries = this.cache.getAll(keys);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)entries.get((Object)creationMetaDataKey);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)entries.get((Object)accessMetaDataKey);
        if (creationMetaDataEntry != null && accessMetaData != null) {
            return new CompositeSessionMetaDataEntry(creationMetaDataEntry, accessMetaData);
        }
        return null;
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        boolean newSession = entry.getCreationMetaData().isNew();
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        Mutator creationMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.creationMetaDataMutatorFactory.createMutator((Object)creationMetaDataKey, (Object)new SessionCreationMetaDataEntry(entry.getCreationMetaData(), entry.getLocalContext()));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        Mutator accessMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.accessMetaDataMutatorFactory.createMutator((Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), accessMutator);
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        return new CompositeSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public boolean remove(String id) {
        this.accessMetaDataCache.remove((Object)new SessionAccessMetaDataKey(id));
        this.creationMetaDataCache.remove((Object)new SessionCreationMetaDataKey(id));
        return true;
    }
}

