/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.marshalling.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSO;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseAuthenticationEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.sso.SSO;

public class CoarseSSOFactory<A, D, L>
implements SSOFactory<CoarseSSOEntry<A, D, L>, A, D, L> {
    private final Cache<String, CoarseAuthenticationEntry<A, D, L>> authenticationCache;
    private final Cache<CoarseSessionsKey, Map<D, String>> sessionsCache;
    private final Marshaller<A, MarshalledValue<A, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSSOFactory(Cache<String, CoarseAuthenticationEntry<A, D, L>> authenticationCache, Cache<CoarseSessionsKey, Map<D, String>> sessionsCache, Marshaller<A, MarshalledValue<A, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.authenticationCache = authenticationCache;
        this.sessionsCache = sessionsCache;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public SSO<A, D, L> createSSO(String id, CoarseSSOEntry<A, D, L> entry) {
        CoarseSessionsKey sessionsKey = new CoarseSessionsKey(id);
        Map<D, String> sessionsValue = entry.getSessions();
        CacheEntryMutator sessionsMutator = new CacheEntryMutator(this.sessionsCache, (Object)sessionsKey, sessionsValue);
        CoarseSessions<D> sessions = new CoarseSessions<D>(sessionsValue, (Mutator)sessionsMutator);
        return new InfinispanSSO<A, D, L>(id, entry.getAuthentication(), sessions, entry.getLocalContext(), this.localContextFactory, this);
    }

    public CoarseSSOEntry<A, D, L> createValue(String id, A authentication) {
        CoarseAuthenticationEntry entry = new CoarseAuthenticationEntry((MarshalledValue)this.marshaller.write(authentication));
        CoarseAuthenticationEntry existingEntry = (CoarseAuthenticationEntry)this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, entry);
        if (existingEntry != null) {
            Map value = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id));
            return new CoarseSSOEntry(authentication, entry.getLocalContext(), value);
        }
        HashMap map = new HashMap();
        HashMap existingMap = (HashMap)this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)new CoarseSessionsKey(id), map);
        return new CoarseSSOEntry(authentication, entry.getLocalContext(), existingMap != null ? existingMap : map);
    }

    public CoarseSSOEntry<A, D, L> findValue(String id) {
        CoarseAuthenticationEntry entry = (CoarseAuthenticationEntry)this.authenticationCache.get((Object)id);
        if (entry == null) {
            return null;
        }
        Map map = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id));
        if (map == null) {
            return null;
        }
        try {
            Object authentication = this.marshaller.read(entry.getAuthentication());
            return new CoarseSSOEntry(authentication, entry.getLocalContext(), map);
        }
        catch (InvalidSerializedFormException e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToActivateAuthentication(e, id);
            return null;
        }
    }

    public void remove(String id) {
        this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)id);
        this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new CoarseSessionsKey(id));
    }
}

