/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import javax.transaction.SystemException;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionMetaData;

public class InfinispanSessionMetaDataFactory<L>
implements SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> {
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> findCreationMetaDataCache;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final boolean transactional;
    private final boolean lockOnRead;

    public InfinispanSessionMetaDataFactory(Cache<? extends Key<String>, ?> cache, boolean lockOnRead) {
        this.creationMetaDataCache = cache;
        this.findCreationMetaDataCache = this.creationMetaDataCache;
        this.accessMetaDataCache = cache;
        this.transactional = cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
        this.lockOnRead = lockOnRead;
    }

    public InfinispanSessionMetaData<L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent((Object)new SessionCreationMetaDataKey(id), key -> new SessionCreationMetaDataEntry(new SimpleSessionCreationMetaData()));
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent((Object)new SessionAccessMetaDataKey(id), key -> new SimpleSessionAccessMetaData());
        return new InfinispanSessionMetaData(creationMetaDataEntry.getMetaData(), accessMetaData, creationMetaDataEntry.getLocalContext());
    }

    public InfinispanSessionMetaData<L> findValue(String id) {
        return this.getValue(id, this.findCreationMetaDataCache);
    }

    public InfinispanSessionMetaData<L> tryValue(String id) {
        return this.getValue(id, (Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>>)this.findCreationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}));
    }

    private InfinispanSessionMetaData<L> getValue(String id, Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache) {
        SessionCreationMetaDataEntry creationMetaDataEntry;
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        if (this.lockOnRead) {
            try {
                if (this.transactional && creationMetaDataCache.getAdvancedCache().getTransactionManager().getStatus() == 0 && !creationMetaDataCache.getAdvancedCache().lock((Object[])new SessionCreationMetaDataKey[]{creationMetaDataKey})) {
                    return null;
                }
            }
            catch (SystemException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((creationMetaDataEntry = (SessionCreationMetaDataEntry)creationMetaDataCache.get((Object)creationMetaDataKey)) != null) {
            SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)accessMetaDataKey);
            if (accessMetaData != null) {
                return new InfinispanSessionMetaData(creationMetaDataEntry.getMetaData(), accessMetaData, creationMetaDataEntry.getLocalContext());
            }
            this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)creationMetaDataKey);
        }
        return null;
    }

    @Override
    public SessionMetaData createSessionMetaData(String id, InfinispanSessionMetaData<L> entry) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        CacheEntryMutator creationMutator = this.transactional && this.creationMetaDataCache.getAdvancedCache().getCacheEntry((Object)creationMetaDataKey).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, new SessionCreationMetaDataEntry<L>(entry.getCreationMetaData(), entry.getLocalContext()));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), (Mutator)creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        CacheEntryMutator accessMutator = this.transactional && this.accessMetaDataCache.getAdvancedCache().getCacheEntry((Object)accessMetaDataKey).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), (Mutator)accessMutator);
        return new SimpleSessionMetaData(creationMetaData, accessMetaData);
    }

    @Override
    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, InfinispanSessionMetaData<L> entry) {
        return new SimpleSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public boolean remove(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(id);
        if (this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).lock((Object[])new SessionCreationMetaDataKey[]{key})) {
            this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionCreationMetaDataKey(id));
            this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAccessMetaDataKey(id));
            return true;
        }
        return false;
    }

    public void evict(String id) {
        this.creationMetaDataCache.evict((Object)new SessionCreationMetaDataKey(id));
        this.accessMetaDataCache.evict((Object)new SessionAccessMetaDataKey(id));
    }
}

