/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class InfinispanSessionManagerFactory<C extends Marshallability, L>
implements SessionManagerFactory<L, TransactionBatch> {
    final Batcher<TransactionBatch> batcher;
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final CommandDispatcher<Scheduler> dispatcher;
    final NodeFactory<Address> memberFactory;
    final CacheProperties properties;
    final Cache<Key<String>, ?> cache;
    final Group group;
    private final KeyAffinityServiceFactory affinityFactory;
    private final SessionFactory<InfinispanSessionMetaData<L>, ?, L> factory;
    private final Scheduler scheduler;
    private final SessionCreationMetaDataKeyFilter filter = new SessionCreationMetaDataKeyFilter();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(InfinispanSessionManagerFactory.createThreadFactory());
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();

    private static ThreadFactory createThreadFactory() {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(InfinispanSessionManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration<C, L> config) {
        this.affinityFactory = config.getKeyAffinityServiceFactory();
        this.cache = config.getCache();
        this.memberFactory = config.getMemberFactory();
        this.batcher = new InfinispanBatcher(this.cache);
        this.properties = new InfinispanCacheProperties(this.cache.getCacheConfiguration());
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(config.getCache(), this.properties);
        this.factory = new InfinispanSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getSessionManagerFactoryConfiguration().getLocalContextFactory());
        CommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.factory);
        this.expirationRegistrar = remover;
        this.scheduler = new SessionExpirationScheduler(this.batcher, remover);
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)this.cache.getName(), (Object)this.scheduler);
        this.group = dispatcherFactory.getGroup();
        this.cache.addListener((Object)this);
        this.schedule((Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache));
    }

    public SessionManager<L, TransactionBatch> createSessionManager(final SessionManagerConfiguration configuration) {
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(configuration.getIdentifierFactory(), this.cache, this.affinityFactory);
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return InfinispanSessionManagerFactory.this.cache;
            }

            @Override
            public CacheProperties getProperties() {
                return InfinispanSessionManagerFactory.this.properties;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return InfinispanSessionManagerFactory.this.batcher;
            }

            @Override
            public CommandDispatcher<Scheduler> getCommandDispatcher() {
                return InfinispanSessionManagerFactory.this.dispatcher;
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistar() {
                return InfinispanSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Group getGroup() {
                return InfinispanSessionManagerFactory.this.group;
            }

            @Override
            public NodeFactory<Address> getMemberFactory() {
                return InfinispanSessionManagerFactory.this.memberFactory;
            }

            @Override
            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return configuration.getInactiveSessionRecorder();
            }
        };
        return new InfinispanSessionManager(this.factory, config);
    }

    private SessionAttributesFactory<?> createSessionAttributesFactory(InfinispanSessionManagerFactoryConfiguration<C, L> configuration) {
        SessionManagerFactoryConfiguration<C, L> config = configuration.getSessionManagerFactoryConfiguration();
        MarshalledValueFactory factory = config.getMarshalledValueFactory();
        Marshallability context = config.getMarshallingContext();
        switch (config.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory((Cache<SessionAttributeNamesKey, Map<String, UUID>>)configuration.getCache(), configuration.getCache(), new MarshalledValueMarshaller(factory, context), this.properties);
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(configuration.getCache(), new MarshalledValueMarshaller(factory, context), this.properties);
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.cache.removeListener((Object)this);
        PrivilegedAction<List> action = () -> this.executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.dispatcher.close();
        this.scheduler.close();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<SessionCreationMetaDataKey, ?> event) {
        Cache cache = event.getCache();
        ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtEnd());
        if (event.isPre()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            try {
                this.executor.submit(() -> this.lambda$dataRehashed$2((Locality)newLocality));
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        } else {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtStart());
            try {
                this.rehashFuture.set(this.executor.submit(() -> this.lambda$dataRehashed$3((Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     */
    private void schedule(Locality oldLocality, Locality newLocality) {
        block32: {
            SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> metaDataFactory = this.factory.getMetaDataFactory();
            CloseableIterator keys = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().iterator();
            Throwable throwable = null;
            while (true) {
                if (!keys.hasNext()) break block32;
                if (Thread.currentThread().isInterrupted()) {
                    break block32;
                }
                Key key = (Key)keys.next();
                if (!this.filter.test(key) || oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                String id = (String)key.getValue();
                Batch batch = this.batcher.createBatch();
                Throwable throwable2 = null;
                try {
                    InfinispanSessionMetaData value = (InfinispanSessionMetaData)metaDataFactory.tryValue(id);
                    if (value != null) {
                        this.scheduler.schedule(id, metaDataFactory.createImmutableSessionMetaData(id, value));
                    }
                    return;
                }
                catch (CacheException e) {
                    batch.discard();
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (batch == null) continue;
                    if (throwable2 != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    batch.close();
                    continue;
                }
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
                break;
            }
            finally {
                if (keys != null) {
                    if (throwable != null) {
                        try {
                            keys.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        keys.close();
                    }
                }
            }
        }
    }

    private /* synthetic */ void lambda$dataRehashed$3(Locality oldLocality, Locality newLocality) {
        this.schedule(oldLocality, newLocality);
    }

    private /* synthetic */ void lambda$dataRehashed$2(Locality newLocality) {
        ((Scheduler)this.dispatcher.getContext()).cancel(newLocality);
    }
}

