/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.WebDeploymentConfiguration;
import org.wildfly.clustering.web.WebDeploymentRequirement;
import org.wildfly.clustering.web.infinispan.routing.LocalRouteLocator;
import org.wildfly.clustering.web.infinispan.routing.RouteLocatorServiceNameProvider;
import org.wildfly.clustering.web.routing.RouteLocator;

public class LocalRouteLocatorServiceConfigurator
extends RouteLocatorServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<RouteLocator> {
    private final WebDeploymentConfiguration deploymentConfiguration;
    private volatile SupplierDependency<String> route;

    public LocalRouteLocatorServiceConfigurator(WebDeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
        this.deploymentConfiguration = deploymentConfiguration;
    }

    @Override
    public RouteLocator get() {
        return new LocalRouteLocator((String)this.route.get());
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.route = new ServiceSupplierDependency(WebDeploymentRequirement.LOCAL_ROUTE.getServiceName(support, this.deploymentConfiguration.getServerName()));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer locator = this.route.register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(locator, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

