/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryExternalizer
implements Externalizer<SessionCreationMetaDataEntry<Object>> {
    public void writeObject(ObjectOutput output, SessionCreationMetaDataEntry<Object> entry) throws IOException {
        SessionCreationMetaData metaData = entry.getMetaData();
        output.writeLong(metaData.getCreationTime().toEpochMilli());
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, (int)metaData.getMaxInactiveInterval().getSeconds());
    }

    public SessionCreationMetaDataEntry<Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData(Instant.ofEpochMilli(input.readLong()));
        metaData.setMaxInactiveInterval(Duration.ofSeconds(IndexSerializer.VARIABLE.readInt((DataInput)input)));
        return new SessionCreationMetaDataEntry<Object>(metaData);
    }

    public Class<SessionCreationMetaDataEntry<Object>> getTargetClass() {
        return SessionCreationMetaDataEntry.class;
    }
}

