/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.cache.sso.CompositeSSOManager;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactory<A, D, S>
implements SSOManagerFactory<A, D, S, TransactionBatch> {
    private final InfinispanSSOManagerFactoryConfiguration configuration;

    public InfinispanSSOManagerFactory(InfinispanSSOManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <C, L> SSOManager<A, D, S, L, TransactionBatch> createSSOManager(SSOManagerConfiguration<C, L> configuration) {
        Cache cache = this.configuration.getCache();
        InfinispanCacheProperties properties = new InfinispanCacheProperties(cache.getCacheConfiguration());
        CoarseSessionsFactory sessionsFactory = new CoarseSessionsFactory(this.configuration.getCache(), (CacheProperties)properties);
        InfinispanSSOFactory factory = new InfinispanSSOFactory(this.configuration.getCache(), (CacheProperties)properties, new MarshalledValueMarshaller(configuration.getMarshalledValueFactory()), configuration.getLocalContextFactory(), sessionsFactory);
        AffinityIdentifierFactory idFactory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), cache, this.configuration.getKeyAffinityServiceFactory());
        InfinispanBatcher batcher = new InfinispanBatcher(cache);
        return new CompositeSSOManager(factory, idFactory, (Batcher)batcher);
    }
}

