/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.sso.AuthenticationEntry;
import org.wildfly.clustering.web.cache.sso.CompositeSSO;
import org.wildfly.clustering.web.cache.sso.SSOFactory;
import org.wildfly.clustering.web.cache.sso.SessionsFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.sso.AuthenticationKey;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class InfinispanSSOFactory<AV, SV, A, D, S, L>
implements SSOFactory<Map.Entry<A, AtomicReference<L>>, SV, A, D, S, L> {
    private final SessionsFactory<SV, D, S> sessionsFactory;
    private final Cache<AuthenticationKey, AuthenticationEntry<AV, L>> cache;
    private final Cache<AuthenticationKey, AuthenticationEntry<AV, L>> findCache;
    private final Marshaller<A, AV> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public InfinispanSSOFactory(Cache<AuthenticationKey, AuthenticationEntry<AV, L>> cache, CacheProperties properties, Marshaller<A, AV> marshaller, LocalContextFactory<L> localContextFactory, SessionsFactory<SV, D, S> sessionsFactory) {
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : cache;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
        this.sessionsFactory = sessionsFactory;
    }

    public SSO<A, D, S, L> createSSO(String id, Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> value) {
        Map.Entry<A, AtomicReference<L>> authenticationEntry = value.getKey();
        Sessions sessions = this.sessionsFactory.createSessions(id, value.getValue());
        return new CompositeSSO(id, authenticationEntry.getKey(), sessions, authenticationEntry.getValue(), this.localContextFactory, (Remover)this);
    }

    public Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> createValue(String id, A authentication) {
        try {
            AuthenticationEntry entry = new AuthenticationEntry(this.marshaller.write(authentication));
            this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)new AuthenticationKey(id), (Object)entry);
            Object sessions = this.sessionsFactory.createValue((Object)id, null);
            return new AbstractMap.SimpleImmutableEntry<AbstractMap.SimpleImmutableEntry<A, AtomicReference>, Object>(new AbstractMap.SimpleImmutableEntry<A, AtomicReference>(authentication, entry.getLocalContext()), sessions);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> findValue(String id) {
        Object sessions;
        AuthenticationEntry entry = (AuthenticationEntry)this.findCache.get((Object)new AuthenticationKey(id));
        if (entry != null && (sessions = this.sessionsFactory.findValue((Object)id)) != null) {
            try {
                Object authentication = this.marshaller.read(entry.getAuthentication());
                return new AbstractMap.SimpleImmutableEntry<AbstractMap.SimpleImmutableEntry<Object, AtomicReference>, Object>(new AbstractMap.SimpleImmutableEntry<Object, AtomicReference>(authentication, entry.getLocalContext()), sessions);
            }
            catch (IOException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateAuthentication(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public boolean remove(String id) {
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).remove((Object)new AuthenticationKey(id));
        this.sessionsFactory.remove((Object)id);
        return true;
    }

    public SessionsFactory<SV, D, S> getSessionsFactory() {
        return this.sessionsFactory;
    }
}

