/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.AbstractMap;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocator;

public class PrimaryOwnerRouteLocatorTestCase {
    @Test
    public void test() {
        Function locator = (Function)Mockito.mock(Function.class);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Group group = (Group)Mockito.mock(Group.class);
        Node primary = (Node)Mockito.mock(Node.class);
        Node local = (Node)Mockito.mock(Node.class);
        Node missing = (Node)Mockito.mock(Node.class);
        String primaryRoute = "primary";
        String localRoute = "local";
        Mockito.when((Object)registry.getGroup()).thenReturn((Object)group);
        Mockito.when((Object)group.getLocalMember()).thenReturn((Object)local);
        Mockito.when((Object)registry.getEntry(local)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>(localRoute, null));
        PrimaryOwnerRouteLocator routeLocator = new PrimaryOwnerRouteLocator(locator, registry);
        Mockito.when((Object)((Node)locator.apply(new GroupedKey((Object)"session")))).thenReturn((Object)primary);
        Mockito.when((Object)registry.getEntry(primary)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>(primaryRoute, null));
        String result = routeLocator.locate("session");
        Assert.assertSame((Object)primaryRoute, (Object)result);
        Mockito.when((Object)((Node)locator.apply(new GroupedKey((Object)"missing")))).thenReturn((Object)missing);
        Mockito.when((Object)registry.getEntry(missing)).thenReturn(null);
        result = routeLocator.locate("missing");
        Assert.assertSame((Object)localRoute, (Object)result);
    }
}

