/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.Evictor;
import org.wildfly.clustering.web.infinispan.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.security.manager.GetAccessControlContextAction;

public class SessionEvictionScheduler
implements Scheduler<ImmutableSession> {
    final Queue<String> evictionQueue = new ConcurrentLinkedQueue<String>();
    final Batcher batcher;
    final Evictor<String> evictor;
    private final ExecutorService executor;
    private final int maxSize;

    public SessionEvictionScheduler(Batcher batcher, Evictor<String> evictor, int maxSize) {
        this(batcher, evictor, maxSize, Executors.newCachedThreadPool(SessionEvictionScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return new JBossThreadFactory(new ThreadGroup(SessionEvictionScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    }

    public SessionEvictionScheduler(Batcher batcher, Evictor<String> evictor, int maxSize, ExecutorService executor) {
        this.batcher = batcher;
        this.evictor = evictor;
        this.maxSize = maxSize;
        this.executor = executor;
    }

    @Override
    public void cancel(ImmutableSession session) {
        this.evictionQueue.remove(session.getId());
    }

    @Override
    public void schedule(ImmutableSession session) {
        this.evictionQueue.add(session.getId());
        while (this.evictionQueue.size() > this.maxSize) {
            String id = this.evictionQueue.poll();
            if (id == null) continue;
            this.executor.submit(new EvictionTask(id));
        }
    }

    @Override
    public void close() {
        this.evictionQueue.clear();
        this.executor.shutdown();
    }

    private class EvictionTask
    implements Runnable {
        private final String id;

        EvictionTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Batch batch = SessionEvictionScheduler.this.batcher.startBatch();
            boolean success = false;
            try {
                SessionEvictionScheduler.this.evictor.evict(this.id);
                success = true;
            }
            finally {
                if (success) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
        }
    }
}

