/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.Remover;
import org.wildfly.clustering.web.infinispan.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.security.manager.GetAccessControlContextAction;

public class SessionExpirationScheduler
implements Scheduler<ImmutableSession> {
    final Map<String, Future<?>> expirationFutures = new ConcurrentHashMap();
    final Batcher batcher;
    final Remover<String> remover;
    private final ScheduledExecutorService executor;

    public SessionExpirationScheduler(Batcher batcher, Remover<String> remover) {
        this(batcher, remover, Executors.newSingleThreadScheduledExecutor(SessionExpirationScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return new JBossThreadFactory(new ThreadGroup(SessionExpirationScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    }

    public SessionExpirationScheduler(Batcher batcher, Remover<String> remover, ScheduledExecutorService executor) {
        this.batcher = batcher;
        this.remover = remover;
        this.executor = executor;
    }

    @Override
    public void cancel(ImmutableSession session) {
        Future<?> future = this.expirationFutures.remove(session.getId());
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void schedule(ImmutableSession session) {
        long timeout = session.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS);
        if (timeout > 0L) {
            String id = session.getId();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will expire in %d ms", id, timeout);
            this.expirationFutures.put(id, this.executor.schedule(new ExpirationTask(id), timeout, TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private class ExpirationTask
    implements Runnable {
        private final String id;

        public ExpirationTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SessionExpirationScheduler.this.expirationFutures.remove(this.id);
            InfinispanWebLogger.ROOT_LOGGER.tracef("Expiring session %s", this.id);
            Batch batch = SessionExpirationScheduler.this.batcher.startBatch();
            boolean success = false;
            try {
                SessionExpirationScheduler.this.remover.remove(this.id);
                success = true;
            }
            finally {
                if (success) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
        }
    }
}

