/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.CacheEntryMutator;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class FineSessionFactory<L>
implements SessionFactory<FineSessionCacheEntry<L>, L> {
    private final Cache<String, FineSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache;
    private final CacheInvoker invoker;
    private final SessionContext context;
    private final SessionAttributeMarshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public FineSessionFactory(Cache<String, FineSessionCacheEntry<L>> sessionCache, Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache, CacheInvoker invoker, SessionContext context, SessionAttributeMarshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributeCache = attributeCache;
        this.invoker = invoker;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, FineSessionCacheEntry<L> entry) {
        SessionMetaData metaData = entry.getMetaData();
        Mutator mutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator<String, FineSessionCacheEntry<L>>(this.sessionCache, this.invoker, id, entry, new Flag[0]);
        FineSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, entry.getAttributes(), this.attributeCache, this.invoker, this.marshaller);
        return new InfinispanSession<L>(id, entry.getMetaData(), attributes, entry.getLocalContext(), this.localContextFactory, this.context, mutator, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, FineSessionCacheEntry<L> entry) {
        FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, entry.getAttributes(), this.attributeCache, this.invoker, this.marshaller);
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)entry.getMetaData(), attributes, this.context);
    }

    public FineSessionCacheEntry<L> findValue(String id) {
        return (FineSessionCacheEntry)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)id), new Flag[0]);
    }

    public FineSessionCacheEntry<L> createValue(String id) {
        FineSessionCacheEntry entry = new FineSessionCacheEntry(new SimpleSessionMetaData());
        FineSessionCacheEntry existing = (FineSessionCacheEntry)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)id, entry), new Flag[0]);
        return existing != null ? existing : entry;
    }

    public void remove(final String id) {
        final FineSessionCacheEntry entry = (FineSessionCacheEntry)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)id), new Flag[0]);
        CacheInvoker.Operation<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>, Void> attributeOperation = new CacheInvoker.Operation<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>, Void>(){

            public Void invoke(Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> cache) {
                for (String attribute : entry.getAttributes()) {
                    cache.remove((Object)new SessionAttributeCacheKey(id, attribute));
                }
                return null;
            }
        };
        this.invoker.invoke(this.attributeCache, (CacheInvoker.Operation)attributeOperation, new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LOCKING});
    }

    public void evict(String id) {
        FineSessionCacheEntry<L> entry = this.findValue(id);
        if (entry != null) {
            for (String attribute : entry.getAttributes()) {
                try {
                    this.attributeCache.evict((Object)new SessionAttributeCacheKey(id, attribute));
                }
                catch (Throwable e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, attribute);
                }
            }
            try {
                this.sessionCache.evict((Object)id);
            }
            catch (Throwable e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
            }
        }
    }
}

